/*
 * 
 */
package com.ejie.ab18a.log;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/**
 * The Class Ab18aLog.
 * @author XXXX
 */
public class Ab18aLog {
	
	/**
	 * Instantiates a new ab18a log.
	 */
	protected Ab18aLog()
	{
		
	}
	
	private static Logger logger = Logger.getLogger(Ab18aLog.class);
	
	/** Indica si el log ha sido configurado */
	private static boolean configurado = false;
	private static boolean configuradoTrazasApp = false;
	

	
	/**
	 * configure : lee el fichero de configuracion de log4j.
	 *
	 * @param appender_name the appender_name
	 * @param tipoLogger the tipo logger
	 */
	public static void configure(String appender_name, int tipoLogger){
		if(tipoLogger == Ab18aConstantesLog.LOGGER_GENERAL && !configurado){
			ConsoleAppender logAppender = (ConsoleAppender) logger.getAppender(appender_name);
			if(logAppender==null)
				logAppender=new ConsoleAppender(new PatternLayout(Ab18aConstantesLog.PATRON_LOG), ConsoleAppender.SYSTEM_OUT);
			logAppender.setName(appender_name);
			Ab18aLog.logger.addAppender(logAppender);
			Ab18aLog.configurado = true;
		} else if(tipoLogger == Ab18aConstantesLog.LOGGER_APP && !configuradoTrazasApp){
			Ab18aLog.configuradoTrazasApp = true;
		} 
	}

	/**
	 * debug : Escribe un mensaje de log con nivel DEBUG
	 * @param clase : Clase desde donde se ejecuta la orden de escribir a log
	 * @param metodo : Metodo desde donde se ejecuta la orden de escribir a log
	 * @param tipoLogger : Tipo de logger
	 * @param log : Texto a escribir en log
	 */
	
	public static void debug (String clase, String metodo, String log, int tipoLogger)
	{
		if (tipoLogger == Ab18aConstantesLog.LOGGER_GENERAL)
			logger.debug("Clase: " + clase + " - metodo: " + metodo + " => " + log);
	
			
	}
	
	/**
	 * info : Escribe un mensaje de log con nivel INFO
	 * @param clase : Clase desde donde se ejecuta la orden de escribir a log
	 * @param metodo : Metodo desde donde se ejecuta la orden de escribir a log
	 * @param log : Texto a escribir en log
	 * @param tipoLogger : Tipo de logger
	 */
	
	public static void info (String clase, String metodo, String log, int tipoLogger)
	{
		if (tipoLogger == Ab18aConstantesLog.LOGGER_GENERAL)
			logger.info("Clase: " + clase + " - metodo: " + metodo + " => " + log);
		
			
	}
	
	/**
	 * warn : Escribe un mensaje de log con nivel WARN
	 * @param clase : Clase desde donde se ejecuta la orden de escribir a log
	 * @param metodo : Metodo desde donde se ejecuta la orden de escribir a log
	 * @param log : Texto a escribir en log
	 * @param tipoLogger : Tipo de logger
	 */
	
	public static void warn (String clase, String metodo, String log, int tipoLogger)
	{
		if (tipoLogger == Ab18aConstantesLog.LOGGER_GENERAL)
			logger.warn("Clase: " + clase + " - metodo: " + metodo + " => " + log);
		
			
	}
	
	/**
	 * error :  Escribe un mensaje de log con nivel ERROR
	 * @param clase : Clase desde donde se ejecuta la orden de escribir a log
	 * @param metodo : Metodo desde donde se ejecuta la orden de escribir a log
	 * @param log : Texto a escribir en log
	 * @param tipoLogger : Tipo de logger
	 */
	
	public static void error (String clase, String metodo, String log, int tipoLogger)
	{
		if (tipoLogger == Ab18aConstantesLog.LOGGER_GENERAL)
			logger.error("Clase: " + clase + " - metodo: " + metodo + " => " + log);
		
			
	}
	
	/**
	 * fatal :  Escribe un mensaje de log con nivel FATAL
	 * @param clase : Clase desde donde se ejecuta la orden de escribir a log
	 * @param metodo : Metodo desde donde se ejecuta la orden de escribir a log
	 * @param log : Texto a escribir en log
	 * @param tipoLogger : Tipo de logger
	 */
	
	public static void fatal (String clase, String metodo, String log, int tipoLogger)
	{
		if (tipoLogger == Ab18aConstantesLog.LOGGER_GENERAL)
			logger.fatal("Clase: " + clase + " - metodo: " + metodo + " => " + log);
		
			
	}
}
